$Networking::ConnectIP = "aloshi.nitramtj.com";
$Networking::Port = "28000";


if(!isObject(PlayerGroup))
{
	new SimGroup(PlayerGroup);
}

//create a client
function clientCmdCreateClient(%name, %id)
{
	%obj = new t2dStaticSprite(){
      imageMap = "player_down0ImageMap";
      frame = "0";
      size = "3.5 3.5";
      Layer = "0";
      CollisionPolyList = "-0.496 -0.751 0.491 -0.751 0.491 0.742 -0.496 0.742";
      name = %name;
      clientid = %id;
  };
  $Player.scenegraph.add(%obj);
  PlayerGroup.add(%obj);  
}

function clientCmdDeleteClient(%id)
{
	findPlayerById(%id).delete();
}

function clientCmdClearPlayerList()
{
	while(PlayerGroup.getCount() > 0)
	{
		PlayerGroup.getObject(0).delete();
	}
}

function clientCmdUpdatePlayerStatus(%id, %x, %y, %img, %vx, %vy)
{
	%client = findPlayerById(%id);
	%client.setPosition(%x, %y);
	%client.setLinearVelocity(%vx, %vy);
	%client.setImageMap(%img);
}

//for convenience =========================================================================================
//find a player in the playerGroup by their client id
function findPlayerById(%id)
{
	for(%i = 0; %i < playerGroup.getCount(); %i++)
	{
		if(playerGroup.getObject(%i).clientid == %id)
			return(playerGroup.getObject(%i));
	}
	
	error("Player not found for findPlayerById!");
}

//find a player in the playerGroup by their name
function findPlayerByName(%name)
{
	for(%i = 0; %i < playerGroup.getCount(); %i++)
	{
		if(playerGroup.getObject(%i).name $= %name)
			return(playerGroup.getObject(%i));
	}
	
	for(%i = 0; %i < playerGroup.getCount(); %i++)
	{
		%chk = playerGroup.getObject(%i).name;
		if(strReplace(%chk, %name, "") !$= %chk)
			return(playerGroup.getObject(%i));
	}
	
	error("Player not found for findPlayerByName!");
}

//=========================
//CLIENT
//=========================
function connectToServer(%ip)
{
   // Just in case we're already connected.
   disconnect();
   
   if(%ip $= "")
   {
			%ip = $Networking::ConnectIP @ ":" @ $Networking::Port;
      //MessageBoxOK("Cannot connect to server. IP address not specified.");
      //return;
   }

   %conn = new GameConnection(ServerConnection);
   
   $pref::Player::name = "Client";
   
   %conn.setConnectArgs($pref::Player::name);
   %conn.connect(%ip);
   
   $serverConnected = true;
   $serverLocal = false;
}

//-----------------------------------------------------------------------------
// disconnect
//-----------------------------------------------------------------------------
function disconnect()
{
   if(!$serverConnected)
      return;
      
   if (isObject(ServerConnection))
      ServerConnection.delete();

   // If we were the host, make sure the server is destroyed.
   if ($serverLocal)
      destroyServer();
      
   disconnectedCleanup();
}

function disconnectedCleanup()
{
   // Clean everything up.
   //alxStopAll();
   //clearTextureHolds();
   //purgeResources();
   clientCmdClearPlayerList();
   $serverConnected = false;
   //onDisconnect();
}

//onConnect, errors, etc
function clientCmdSetConnectionError(%error)
{
   $ServerConnectionErrorMessage = %error;
}

function GameConnection::onConnectionAccepted(%this)
{
   onConnect();
}

//---------------------------------------------------------------------------------------------
// GameConnection.onConnectionTimedOut
// A connection was established with the server, but has since timed out.
//---------------------------------------------------------------------------------------------
function GameConnection::onConnectionTimedOut(%this)
{
   disconnectedCleanup();
   MessageBoxOK("TIMED OUT", "The server connection has timed out.");
}

//---------------------------------------------------------------------------------------------
// GameConnection.onConnectionTimedOut
// A connection was established with the server, but has since been dropped.
//---------------------------------------------------------------------------------------------
function GameConnection::onConnectionDropped(%this, %msg)
{
   disconnectedCleanup();
   MessageBoxOK("DISCONNECT", "The server has dropped the connection: " @ %msg);
}

//---------------------------------------------------------------------------------------------
// GameConnection.onConnectionTimedOut
// A connection was established with the server, but some error (sent to 'SetConnectionError')
// has occured.
//---------------------------------------------------------------------------------------------
function GameConnection::onConnectionError(%this, %msg)
{
   disconnectedCleanup();
   MessageBoxOK("DISCONNECT", $ServerConnectionErrorMessage @ " (" @ %msg @ ")");
}


//---------------------------------------------------------------------------------------------
// GameConnection.onConnectionTimedOut
// A connection was not able to be made with the server because the server rejected it.
//---------------------------------------------------------------------------------------------
function GameConnection::onConnectRequestRejected(%this, %msg)
{
   switch$(%msg)
   {
      case "CHR_PASSWORD":
         if ($Client::Password $= "")
            %error = "The server requires a password.";
         else
            %error = "The password you entered is incorrect.";
            
      case "CHR_PROTOCOL":
         %error = "Incompatible protocol version: Your game version is not compatible with this server.";
         
      default:
         %error = "Connection error. Please try another server. Error code: (" @ %msg @ ")";
   }
   
   disconnectedCleanup();
   MessageBoxOK("REJECTED", %error);
}

//---------------------------------------------------------------------------------------------
// GameConnection.onConnectionRequestTimedOut
// A connection was not able to be made with the server and the request timed out.
//---------------------------------------------------------------------------------------------
function GameConnection::onConnectRequestTimedOut(%this)
{
   disconnectedCleanup();
   MessageBoxOK("TIMED OUT", "Your connection to the server timed out.");
}
